<?php
/* 
	Copyright 2011 Informtica de Municpios Associados
	Este arquivo  parte do programa DIM
	O DIM  um software livre; voc pode redistribu-lo e/ou modific-lo dentro dos termos da Licena Pblica Geral GNU como publicada pela Fundao do Software Livre (FSF); na verso 2 da Licena.
	Este programa  distribudo na esperana que possa ser  til, mas SEM NENHUMA GARANTIA; sem uma garantia implcita de ADEQUAO a qualquer  MERCADO ou APLICAO EM PARTICULAR. Veja a Licena Pblica Geral GNU/GPL em portugus para maiores detalhes.
	Voc deve ter recebido uma cpia da Licena Pblica Geral GNU, sob o ttulo "LICENCA.txt", junto com este programa, se no, acesse o Portal do Software Pblico Brasileiro no endereo www.softwarepublico.gov.br ou escreva para a Fundao do Software Livre(FSF) Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA.
*/

// +---------------------------------------------------------------------------------+
// | IMA - Informtica de Municpios Associados S/A - Copyright (c) 2007             |
// +---------------------------------------------------------------------------------+
// | Sistema ............: DIM - Dispensao Individualizada de Medicamentos         |
// | Arquivo ............: Class.Pdf.inc.php                                         |
// | Autor ..............: Jos Renato C. P. Barbosa <jrenato.barbosa@ima.sp.gov.br> |
// +---------------------------------------------------------------------------------+
// | Funo .............: Classe base dos Relatrios (.pdf)                         |
// | Data de Criao ....: 11/01/2007                                                |
// | ltima Atualizao .: 15/01/2007 - 14:20                                        |
// | Verso .............: 1.0.0                                                     |
// +---------------------------------------------------------------------------------+

   require("fpdf.php");

   class PDF extends FPDF
   {
      var $nome;  //nome do relatorio
      var $unidade; // unidade a qual pertence o usurio
      var $cabecalho; //cabealho para as colunas
      var $aplic;

      function PDF($or = "P")   //construtor: Chama a classe FPDF
      {
         $this->FPDF($or);
      }
      
      function SetCabecalho($cab)  // define o cabealho
      {
         $this->cabecalho = $cab;
      }
      
      function SetName($nomerel)   // nomeia o relatorio
      {
         $this->nome = $nomerel;
      }
      
      function SetUnd($nome_und)   // nomeia o relatorio
      {
         $this->unidade = $nome_und;
      }
      
      function SetNomeAplic($nome_aplic)   // nomeia o Aplicao
      {
         $this->aplic = $nome_aplic;
      }
      
      function Header()
      {
         $this->AliasNbPages();  // Define o nmero total de paginas para a macro {nb}
         $this->Image("../../imagens/brasao_peqno.jpg",8,2,18,18); // importa uma imagem
         //$this->Image("../../imagens/DIM_logo_pequeno.jpg",178,2,22,18); // importa uma imagem - Retrato
         $this->Image("../../imagens/DIM_logo_pequeno.jpg",265,2,22,18); // importa uma imagem  - Paisagem

         $this->SetFont("Helvetica","B",10);
         $this->SetTextColor(165,0,0);
         $this->Cell(0,5,"Unidade: ".$this->unidade,0,1,"C");
         $this->Cell(0,5,$this->nome,0,1,"C");
         $this->SetFont("Arial","",10);
         $this->SetX(-10);
         $this->Line(10,22,$this->GetX(),22);   //Desenha uma linha
         if( $this->cabecalho ) //Se tem Cabealho, Imprime
         {
            $this->SetFont("Arial","",10);
            $this->SetX(10);
            $this->Cell($this->GetStringWidth($this->cabecalho),5,$this->cabecalho,0,1);
         }
      }
      
      function Footer()   // Rodap: imprime a hora de impresso e copyright
      {
         $this->SetXY(-10,-8);
         $this->Line(10,$this->GetY()-2, $this->GetX(), $this->GetY()-2);
         $this->SetX(0);
         $this->SetTextColor(0,0,0);
         $this->SetFont("Arial","",8);
         $this->Cell(10,5,"",0,0);
         $this->Cell($this->GetStringWidth($this->aplic),5,$this->aplic,0,0,"L");
         $data = strftime("%d/%m/%Y  %T");
         //$this->Cell(70,5,"pg. [".$this->PageNo()."] de [{nb}]",0,0,"C"); //  Imprime pgina X/Total de Pginas - Retrato
         $this->Cell(200,5,"pg. [".$this->PageNo()."] de [{nb}]",0,0,"C"); //  Imprime pgina X/Total de Pginas - Paisagem
         $this->Cell(0,5,$data,0,0,"R");
      }
   }
?>
